ORCA/M Asm65816 2.1.0

0001 17E2                       PRINT   NODATA 
0002 17E2                       TITLE   '     Direct Read Equates' 
0003 17E2              ****************************************************
0004 17E2              * Revision history for a direct.Read routine
0005 17E2              * that will work in Bank $01 RAM 
0006 17E2              *
0007 17E2              * Derived from TenSpeed Sources on Feb 2, 1989
0008 17E2              *
0009 17E2              ****************************************************;
0010 17E2              ***************************************************************
0011 17E2              *
0012 17E2              *        **** WARNING **** WARNING **** WARNING ****
0013 17E2              *
0014 17E2              *    The order of this source code is critical to the
0015 17E2              *    generation of the object segment.  The ASHIFT, BSHIFT,
0016 17E2              *    DENIBLTBL, READ routine and then the CSHIFTBL
0017 17E2              *    must be in THAT SPECIFIC sequential order.  
0018 17E2              *    OTHERWISE the positions of the nyble tables will be wrong.
0019 17E2              *
0020 17E2              *******************************************
0021 17E2              bank1_code proc export
0022 17E2                       endp 
0023 17E2                       ENTRY DIRECT_READ
0024 17E2              read1to1 PROC temporg  $01bc00
0025 17E2                       EXPORT DIRECT_READ
0026 17E2                       export beg_bank1
0027 17E2                       export end_bank1
0028 17E2              *
0029 17E2              *  IWM EQUATES :  These equates assume DBR points to an I/O bank !!!
0030 17E2              *
0031 17E2              DB_IWM   EQU   $C0E0
0032 17E2              *
0033 17E2              DR_CA0CLR EQU   DB_IWM+0
0034 17E2              DR_CA0SET EQU   DB_IWM+1
0035 17E2              DR_CA1CLR EQU   DB_IWM+2
0036 17E2              DR_CA1SET EQU   DB_IWM+3
0037 17E2              DR_CA2CLR EQU   DB_IWM+4
0038 17E2              DR_CA2SET EQU   DB_IWM+5
0039 17E2              DR_LSTRBCLR EQU   DB_IWM+6
0040 17E2              DR_LSTRBSET EQU   DB_IWM+7
0041 17E2              DR_DESELECT EQU   DB_IWM+8
0042 17E2              DR_SELECT EQU   DB_IWM+9
0043 17E2              DR_ENABLE1 EQU   DB_IWM+10
0044 17E2              DR_ENABLE2 EQU   DB_IWM+11
0045 17E2              DR_L6CLR EQU   DB_IWM+12
0046 17E2              DR_L6SET EQU   DB_IWM+13
0047 17E2              DR_L7CLR EQU   DB_IWM+14
0048 17E2              DR_L7SET EQU   DB_IWM+15
0049 17E2
0050 17E2                       TITLE '      Extra Bits Shift Tables'
0051 17E2              beg_bank1  
0052 17E2 00 00 00 00  ASHIFT   DC B:0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
0053 17F2 40 40 40 40           DC B:64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64
0054 1802 80 80 80 80           DC B:128,128,128,128,128,128,128,128
0055 180A 80 80 80 80           DC B:128,128,128,128,128,128,128,128
0056 1812 C0 C0 C0 C0           DC B:192,192,192,192,192,192,192,192
0057 181A C0 C0 C0 C0           DC B:192,192,192,192,192,192,192,192
0058 1822              *
0059 1822 00 00 00 00  BSHIFT   DC B:0,0,0,0,64,64,64,64
0060 182A 80 80 80 80           DC B:128,128,128,128,192,192,192,192
0061 1832 00 00 00 00           DC B:0,0,0,0,64,64,64,64
0062 183A 80 80 80 80           DC B:128,128,128,128,192,192,192,192
0063 1842 00 00 00 00           DC B:0,0,0,0,64,64,64,64
0064 184A 80 80 80 80           DC B:128,128,128,128,192,192,192,192
0065 1852 00 00 00 00           DC B:0,0,0,0,64,64,64,64
0066 185A 80 80 80 80           DC B:128,128,128,128,192,192,192,192
0067 1862              *
0068 1862 AD AA D5     DATAMARKS DC B:$AD,$AA,$D5
0069 1865 FF AA DE     BSMARKS  DC B:$FF,$AA,$DE
0070 1868              *
0071 1868              * ABSOLUTE WORK SPACE (max of 16 bytes)
0072 1868 00           SECTCHK  DS B:1
0073 1869              * Now Pad up to $XX96 
0074 1869 00 00 00 00           DS B:15
0075 1878                       TITLE '                        Denibbilizing Table'
0076 1878              ******************************************************
0077 1878              *                                                    *
0078 1878              *          7 bit to 6 bit 'Deniblize' Table          *
0079 1878              *                                                    *
0080 1878              *          Valid codes are $96 to $FF only           *
0081 1878              *     Codes with more than one pair of adjacent      *
0082 1878              *      zeroes or with no adjacent ones (except       *
0083 1878              *               bit 7) are excluded.                 *
0084 1878              *                                                    *
0085 1878              *      This table *must* be aligned at the end       *
0086 1878              *               of a page in memory.                 *
0087 1878              *                                                    *
0088 1878              ******************************************************
0089 1878              DNIBTAB  EQU   *-$96
0090 1878              *
0091 1878 00 01 98              DC B:$00,$01,$98
0092 187B 99 02 03              DC B:$99,$02,$03
0093 187E 9C 04 05              DC B:$9C,$04,$05
0094 1881 06 A0 A1              DC B:$06,$A0,$A1
0095 1884 A2 A3 A4              DC B:$A2,$A3,$A4
0096 1887 A5 07 08              DC B:$A5,$07,$08
0097 188A A8 A9 AA              DC B:$A8,$A9,$AA
0098 188D 09 0A 0B              DC B:$09,$0A,$0B
0099 1890 0C 0D B0              DC B:$0C,$0D,$B0
0100 1893 B1 0E 0F              DC B:$B1,$0E,$0F
0101 1896 10 11 12              DC B:$10,$11,$12
0102 1899 13 B8 14              DC B:$13,$B8,$14
0103 189C 15 16 17              DC B:$15,$16,$17
0104 189F 18 19 1A              DC B:$18,$19,$1A
0105 18A2 C0 C1 C2              DC B:$C0,$C1,$C2
0106 18A5 C3 C4 C5              DC B:$C3,$C4,$C5
0107 18A8 C6 C7 C8              DC B:$C6,$C7,$C8
0108 18AB C9 CA 1B              DC B:$C9,$CA,$1B
0109 18AE CC 1C 1D              DC B:$CC,$1C,$1D
0110 18B1 1E D0 D1              DC B:$1E,$D0,$D1
0111 18B4 D2 1F D4              DC B:$D2,$1F,$D4
0112 18B7 D5 20 21              DC B:$D5,$20,$21
0113 18BA D8 22 23              DC B:$D8,$22,$23
0114 18BD 24 25 26              DC B:$24,$25,$26
0115 18C0 27 28 E0              DC B:$27,$28,$E0
0116 18C3 E1 E2 E3              DC B:$E1,$E2,$E3
0117 18C6 E4 29 2A              DC B:$E4,$29,$2A
0118 18C9 2B E8 2C              DC B:$2B,$E8,$2C
0119 18CC 2D 2E 2F              DC B:$2D,$2E,$2F
0120 18CF 30 31 32              DC B:$30,$31,$32
0121 18D2 F0 F1 33              DC B:$F0,$F1,$33
0122 18D5 34 35 36              DC B:$34,$35,$36
0123 18D8 37 38 F8              DC B:$37,$38,$F8
0124 18DB 39 3A 3B              DC B:$39,$3A,$3B
0125 18DE 3C 3D 3E              DC B:$3C,$3D,$3E
0126 18E1 3F                    DC B:$3F
0127 18E2                       TITLE '     Direct Read Data Field'
0128 18E2              **********************************************************
0129 18E2              *                                                        *
0130 18E2              * DirectRead: Read data field directly to users buffer   *
0131 18E2              *                                                        *
0132 18E2              *   Assumes: the user buffer is in fast ram              *
0133 18E2              *            i.e. not in $E0-E1 or $00-01 with shadowing *
0134 18E2              *         and the buffer does NOT span a bank boundary!! *
0135 18E2              *                                                        *
0136 18E2              *   Output:   512 bytes stored in user buffer            *
0137 18E2              *                                                        *
0138 18E2              **********************************************************
0139 18E2              *                                                        *
0140 18E2              * WARNING:   The size of this DS.B may need to change if *
0141 18E2              *            this routine is changed in length !!!!!!!!!!*
0142 18E2              **********************************************************
0143 18E2 00 00 00 00           DS B:$18                       ;pad to put pgcross in right place!!!!
0144 18FA              *
0145 18FA 8B           DIRECT_READ PHB   
0146 18FB 4B                    PHK   
0147 18FC AB                    PLB                            ;POINT   data bank at mycode/tables
0148 18FD              *
0149 18FD 8D 86 BC              STA   SECTCHK                  ;save sect# to verify
0150 1900 64 0F                 STZ   CSUMA
0151 1902 64 0E                 STZ   CSUMB
0152 1904 64 0D                 STZ   CSUMC
0153 1906              *
0154 1906              * Find the data marks
0155 1906              *
0156 1906 A0 19                 LDY   #READTO                  ;Rather short timeout
0157 1908 A2 02        @02      LDX   #2                       ;Three of 'em
0158 190A 88           @04      DEY                            ;MAINTAIN        t.o. ctr
0159 190B F0 6A                 BEQ   @TO_ERR                  ;=> Too many bytes passed 
0160 190D              * 
0161 190D AD EC C0              LDA   DR_L6CLR                 ;Look for a byte
0162 1910 10 FB                 BPL   *-3                      ;Branch if no byte ready
0163 1912 DD 80 BC              CMP   DATAMARKS,X              ;Is it the right mark? 
0164 1915 D0 F1                 BNE   @02                      ;No, start all over 
0165 1917
0166 1917 CA                    DEX                            ;YES,    found a mark 
0167 1918 10 F0                 BPL   @04                      ;If more marks, go back 
0168 191A              *
0169 191A              * Found the data marks. Verify the sector number matches adrs field
0170 191A              *
0171 191A AE EC C0              LDX   DR_L6CLR
0172 191D 10 FB                 BPL   *-3
0173 191F              *
0174 191F BD 00 BC              LDA   DNIBTAB,X                ;Denibblize the sector mark
0175 1922 4D 86 BC              EOR   SECTCHK                  ;leave zero in A for cksum algorthm
0176 1925 D0 54                 BNE   @WS_ERR
0177 1927              *
0178 1927              * Now read the 16 nybl (12 bytes) tag field
0179 1927              *
0180 1927 A0 0C                 LDY   #12
0181 1929 18                    CLC   
0182 192A AE EC C0     @TAGLOOP LDX   DR_L6CLR                 ;(6-9,11)
0183 192D              *
0184 192D 10 FB                 BPL   *-3                      ;(3)
0185 192F 65 0D                 ADC   CSUMC                    ;(2)
0186 1931 C9 80                 CMP   #$80                     ;(2)
0187 1933 2A                    ROL   A                        ;(2)
0188 1934 85 0D                 STA   CSUMC                    ;(3)
0189 1936 BD 00 BC              LDA   DNIBTAB,X                ;(4)
0190 1939 85 02                 STA   EXINDEX                  ;(3)
0191 193B AE EC C0              LDX   DR_L6CLR                 ;(6-9,11)
0192 193E              *
0193 193E 10 FB                 BPL   *-3                      ;(3)
0194 1940 BD 00 BC              LDA   DNIBTAB,X                ;(3)
0195 1943 A6 02                 LDX   EXINDEX                  ;(3)
0196 1945 1D 00 BC              ORA   ASHIFT,X                 ;(4)
0197 1948 45 0D                 EOR   CSUMC                    ;(3)
0198 194A 65 0F                 ADC   CSUMA                    ;(3) just perform cksum algorithm
0199 194C 85 0F                 STA   CSUMA                    ;(3)
0200 194E 88                    DEY                            ;(2)     dey  ;(2)
0201 194F
0202 194F AE EC C0              LDX   DR_L6CLR                 ;(6-9,11)
0203 1952              *
0204 1952 10 FB                 BPL   *-3                      ;(3)
0205 1954 BD 00 BC              LDA   DNIBTAB,X                ;(3)
0206 1957 A6 02                 LDX   EXINDEX                  ;(3)
0207 1959 1D 40 BC              ORA   BSHIFT,X                 ;(4)
0208 195C 45 0F                 EOR   CSUMA                    ;(3)
0209 195E 65 0E                 ADC   CSUMB                    ;(3)
0210 1960 85 0E                 STA   CSUMB                    ;(3)
0211 1962 88                    DEY                            ;(2)     dey  ;(2)
0212 1963
0213 1963 AE EC C0              LDX   DR_L6CLR                 ;(6-9,11)
0214 1966              *
0215 1966 10 FB                 BPL   *-3                      ;(3)
0216 1968 BD 00 BC              LDA   DNIBTAB,X                ;(3)
0217 196B A6 02                 LDX   EXINDEX                  ;(3)
0218 196D 1D A1 BE              ORA   CSHIFT,X                 ;(4)
0219 1970 45 0E                 EOR   CSUMB                    ;(3)
0220 1972 88                    DEY                            ;(2)     dey  ;(2)
0221 1973
0222 1973 D0 B5                 BNE   @TAGLOOP                 ;(3)
0223 1975 80 31                 BRA   @GO                      ;(3) enter the 1st page loop
0224 1977              *********************************************
0225 1977 A9 04        @TO_ERR  LDA   #TOERROR
0226 1979 80 02                 BRA   @GOERR
0227 197B A9 20        @WS_ERR  LDA   #WSERROR
0228 197D 82 00 01     @GOERR   BRL   @ERRXIT
0229 1980              *
0230 1980              * Now read the 1st 256 data bytes of data field
0231 1980              *
0232 1980 AE EC C0     @PG1LOOP LDX   DR_L6CLR                 ;(6-9,11) (best-worst,loop)
0233 1983 10 FB                 BPL   *-3                      ;(3)  get nybl B
0234 1985 BD 00 BC              LDA   DNIBTAB,X                ;(3) Denib: 00BBBBBB
0235 1988 A6 02                 LDX   EXINDEX                  ;(3) top bits index
0236 198A 1D 40 BC              ORA   BSHIFT,X                 ;(4) BBBBBBBB XOR csuma
0237 198D 45 0F                 EOR   CSUMA                    ;(3) BBBBBBBB
0238 198F 97 04                 STA   [drvr_buf_ptr],Y         ;(6) put the data byte b
0239 1991 C8                    INY                            ;(2)
0240 1992 65 0E                 ADC   CSUMB                    ;(3) A <- csumb + byteb 
0241 1994 85 0E                 STA   CSUMB                    ;(3)
0242 1996              *
0243 1996 AE EC C0              LDX   DR_L6CLR                 ;(6-9,11) 4 1us cycles/loop 
0244 1999 10 FB                 BPL   *-3                      ;(3)    get nybl C
0245 199B BD 00 BC              LDA   DNIBTAB,X                ;(3)
0246 199E A6 02                 LDX   EXINDEX                  ;(3)
0247 19A0 1D A1 BE              ORA   CSHIFT,X                 ;(4) Add top bits 
0248 19A3 45 0E                 EOR   CSUMB                    ;(3) Got CCCCCCCC
0249 19A5 97 04                 STA   [drvr_buf_ptr],Y         ;(6)
0250 19A7 C8                    INY                            ;(2)
0251 19A8
0252 19A8              *
0253 19A8 AE EC C0     @GO      LDX   DR_L6CLR                 ;(6-9,11) Get the top bits nybl
0254 19AB 10 FB                 BPL   *-3                      ;(3) Back if no byte 
0255 19AD 65 0D                 ADC   CSUMC                    ;(2)
0256 19AF C9 80                 CMP   #$80                     ;(2)
0257 19B1 2A                    ROL   A                        ;(2)
0258 19B2 85 0D                 STA   CSUMC                    ;(3)
0259 19B4 BD 00 BC              LDA   DNIBTAB,X                ;(4) Denibblize top bit nybl
0260 19B7 85 02                 STA   EXINDEX                  ;(3) 
0261 19B9              *
0262 19B9 AE EC C0              LDX   DR_L6CLR                 ;(6-9,11) Get nybl A
0263 19BC 10 FB                 BPL   *-3                      ;(3) 
0264 19BE BD 00 BC              LDA   DNIBTAB,X                ;(3) Denib: 00AAAAAA
0265 19C1 A6 02                 LDX   EXINDEX                  ;(3) top bit index
0266 19C3 1D 00 BC              ORA   ASHIFT,X                 ;(4) AAAAAAAA XOR csumc
0267 19C6 45 0D                 EOR   CSUMC                    ;(3) AAAAAAAA
0268 19C8 97 04                 STA   [drvr_buf_ptr],Y         ;(6) put the data byte A   
0269 19CA 65 0F                 ADC   CSUMA                    ;(3) Add it in to the carry
0270 19CC 85 0F                 STA   CSUMA                    ;(3) Keep it
0271 19CE C8                    INY                            ;(2)     end of 1st 256 bytes yet?
0272 19CF D0 AF                 BNE   @PG1LOOP                 ;(3)
0273 19D1              *
0274 19D1              * cross over nybl to 2nd loop and 2nd code page!
0275 19D1              * WARNING! The code page boundary must occur within the
0276 19D1              *          following instructions before the loop label
0277 19D1              *
0278 19D1              @DRCHK1  EQU   *
0279 19D1 AE EC C0              LDX   DR_L6CLR                 ;(6-9,11) get the C nybl
0280 19D4 10 FB                 BPL   *-3                      ;(3)
0281 19D6 BD 00 BC              LDA   DNIBTAB,X                ;(3)
0282 19D9 A6 02                 LDX   EXINDEX                  ;(3)
0283 19DB 1D 40 BC              ORA   BSHIFT,X                 ;(4)
0284 19DE 45 0F                 EOR   CSUMA                    ;(3)
0285 19E0 97 1C                 STA   [drvr_buf2_ptr],Y        ;(6)
0286 19E2 65 0E                 ADC   CSUMB                    ;(3)
0287 19E4 85 0E                 STA   CSUMB                    ;(3)
0288 19E6 C8                    INY                            ;(2)
0289 19E7
0290 19E7              @DRCHK2  EQU   *
0291 19E7              *
0292 19E7              * Now read the 2nd 256 data bytes of data field
0293 19E7              *
0294 19E7 AE EC C0     @PG2LOOP LDX   DR_L6CLR                 ;(6-9,11)  (best-worst,loop)
0295 19EA 10 FB                 BPL   *-3                      ;(3)    (4 slow cycles/loop)
0296 19EC BD 00 BC              LDA   DNIBTAB,X                ;(3)
0297 19EF A6 02                 LDX   EXINDEX                  ;(3)
0298 19F1 1D A1 BE              ORA   CSHIFT,X                 ;(4) Add top bits 
0299 19F4 45 0E                 EOR   CSUMB                    ;(3) Got CCCCCCCC
0300 19F6 97 1C                 STA   [drvr_buf2_ptr],Y        ;(6)
0301 19F8 C8                    INY                            ;(2) 
0302 19F9              *
0303 19F9 AE EC C0              LDX   DR_L6CLR                 ;(6-9,11) Get the top bits nybl
0304 19FC 10 FB                 BPL   *-3                      ;(3) Back if no byte 
0305 19FE 65 0D                 ADC   CSUMC                    ;(2)
0306 1A00 C9 80                 CMP   #$80                     ;(2)
0307 1A02 2A                    ROL   A                        ;(2)
0308 1A03 85 0D                 STA   CSUMC                    ;(3)
0309 1A05 BD 00 BC              LDA   DNIBTAB,X                ;(4) Denibblize top bit nybl
0310 1A08 85 02                 STA   EXINDEX                  ;(3) 
0311 1A0A              *
0312 1A0A AE EC C0              LDX   DR_L6CLR                 ;(6-9,11) Get nybl A
0313 1A0D 10 FB                 BPL   *-3                      ;(3) 
0314 1A0F BD 00 BC              LDA   DNIBTAB,X                ;(3) Denib: 00AAAAAA
0315 1A12 A6 02                 LDX   EXINDEX                  ;(3) top bit index
0316 1A14 1D 00 BC              ORA   ASHIFT,X                 ;(4) AAAAAAAA XOR csumc
0317 1A17 45 0D                 EOR   CSUMC                    ;(3) AAAAAAAA
0318 1A19 97 1C                 STA   [drvr_buf2_ptr],Y        ;(6) put the data byte 
0319 1A1B C8                    INY                            ;(2)
0320 1A1C
0321 1A1C 65 0F                 ADC   CSUMA                    ;(3) A <- csuma + bytea 
0322 1A1E 85 0F                 STA   CSUMA                    ;(3) 
0323 1A20              *
0324 1A20 AE EC C0              LDX   DR_L6CLR                 ;(6-9,11) get nybl B
0325 1A23 10 FB                 BPL   *-3                      ;(3)
0326 1A25 BD 00 BC              LDA   DNIBTAB,X                ;(3) Denib: 00BBBBBB
0327 1A28 A6 02                 LDX   EXINDEX                  ;(3)
0328 1A2A 1D 40 BC              ORA   BSHIFT,X                 ;(4) BBBBBBBB XOR csuma
0329 1A2D 45 0F                 EOR   CSUMA                    ;(3) BBBBBBBB 
0330 1A2F 97 1C                 STA   [drvr_buf2_ptr],Y        ;(6) Get rid of byteb
0331 1A31 65 0E                 ADC   CSUMB                    ;(3) Add it in to the carry
0332 1A33 85 0E                 STA   CSUMB                    ;(3) Keep it
0333 1A35 C8                    INY                            ;(2)     done with 2nd page yet? 
0334 1A36 D0 AF                 BNE   @PG2LOOP                 ;(3)
0335 1A38              *
0336 1A38              * Now grab, decode, and verify the checksum bytes
0337 1A38              *
0338 1A38 AE EC C0              LDX   DR_L6CLR                 ;(4) Get the extras
0339 1A3B 10 FB                 BPL   *-3                      ;(2) Wait until byte ready
0340 1A3D BD 00 BC              LDA   DNIBTAB,X                ;(3) Denibbilize it
0341 1A40 AA                    TAX                            ;(2)     save it
0342 1A41 BD A1 BE              LDA   CSHIFT,X                 ;(4) Grab C extras in A[7..6]
0343 1A44 85 02                 STA   EXINDEX                  ;(3) Keep for later
0344 1A46 BD 40 BC              LDA   BSHIFT,X                 ;(4) Get shifted B extras
0345 1A49 85 03                 STA   EXINDEX2                 ;(3)
0346 1A4B BD 00 BC              LDA   ASHIFT,X                 ;(4) Get A extras shifted
0347 1A4E              *
0348 1A4E A0 02                 LDY   #2
0349 1A50              *
0350 1A50 AE EC C0     @80      LDX   DR_L6CLR                 ;(4)
0351 1A53 10 FB                 BPL   *-3                      ;(2) Wait until byte ready
0352 1A55 29 C0                 AND   #$C0                     ;(2) Isolate hi bits in A
0353 1A57 1D 00 BC              ORA   DNIBTAB,X                ;(4) 'or' in denibbed low 6
0354 1A5A BB                    TYX                            ;(2)     need zpg indexed addressing
0355 1A5B D5 0D                 CMP   CSUMC,X                  ;(4) Is it what we calc'd?
0356 1A5D D0 19                 BNE   @110                     ;(2) If not, flag a checksum error
0357 1A5F B5 01                 LDA   EXINDEX-1,X              ;(4) Get next hi set of extras
0358 1A61 88                    DEY                            ;(2)     Almost done
0359 1A62 10 EC                 BPL   @80                      ;(3) Back maybe...
0360 1A64              *
0361 1A64              * Checksum okay... How are the bitslip mark?
0362 1A64              *
0363 1A64 A2 02                 LDX   #2                       ;(2) Got two bitslip marks 
0364 1A66 AD EC C0     @90      LDA   DR_L6CLR                 ;(4) Wait for a byte
0365 1A69 10 FB                 BPL   *-3                      ;(2) 
0366 1A6B DD 83 BC              CMP   BSMARKS,X                ;(4) Right one?
0367 1A6E D0 0C                 BNE   @120                     ;(2) If not, you know where to go
0368 1A70 CA                    DEX                            ;(2)
0369 1A71
0370 1A71 D0 F3                 BNE   @90                      ;(3) Get the other mark
0371 1A73              *
0372 1A73              * Return good...we did it!
0373 1A73              *
0374 1A73 A9 00                 LDA   #00                      ;RETURN ZERO ERROR CODE
0375 1A75 18                    CLC   
0376 1A76 80 09                 BRA   @OKEXIT
0377 1A78              *
0378 1A78              * 'Blew it' so return an error code
0379 1A78              *
0380 1A78 A9 10        @110     LDA   #DCSERROR                ;Data CheckSum Error
0381 1A7A D0 02                 BNE   @RDERR
0382 1A7C              *
0383 1A7C A9 08        @120     LDA   #DBSERROR                ;Data BitSlip Error
0384 1A7E C6 05        @RDERR   DEC   drvr_buf_ptr+1           ;restore buffer adrs
0385 1A80              *
0386 1A80 38           @ERRXIT  SEC   
0387 1A81 AB           @OKEXIT  PLB                            ;restore users DBR
0388 1A82 6B                    RTL   
0389 1A83              *
0390 1A83 00 40 80 C0  CSHIFT   DC B:0,64,128,192,0,64,128,192
0391 1A8B 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0392 1A93 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0393 1A9B 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0394 1AA3 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0395 1AAB 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0396 1AB3 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0397 1ABB 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0398 1AC3              *
0399 1AC3                       string asis
0400 1AC3 A9 20 43 4F           DC B:'© COPYRIGHT 1989 by '
0401 1AD7 41 70 70 6C           DC B:'Apple Computer, Inc'
0402 1AEA 41 6C 6C 20           DC B:'All rights Reserved'
0403 1AFD 4E 4F 54 45           DC B:'NOTE: This code is protected'
0404 1B19 75 6E 64 65           DC B:'under U.S. Patent #4,564,941'
0405 1B35 64 61 74 65           DC B:'dated Jan. 14, 1986'
0406 1B48              end_bank1  
0407 1B48                       ENDPROC 
0408 1B48              *
